/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminConfirmDialog;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

public class VWAdminCancelWork {
    private Vector m_vErrors = new Vector();
    private VWAdminResultPane m_resultsPane;
    private VWTable m_resultsTable;
    private int[] m_selectedRows;
    private int[] m_selectedCols;
    private VWAdminResultTableModelBase m_tableModel;
    private Vector m_wobsList = new Vector();
    private VWParticipant m_logonUser = null;
    private Frame m_parentFrame = null;
    private Container m_mainContainer = null;
    private ListSelectionModel m_listSelectionModel = null;

    public VWAdminCancelWork(VWAdminResultPane resultsPane, boolean bAll) {
        this.m_resultsPane = resultsPane;
        this.m_selectedRows = this.m_resultsPane.getSelectedRows();
        this.m_selectedCols = this.m_resultsPane.getSelectedCols();
        this.m_tableModel = this.m_resultsPane.getTableModel();
        this.m_resultsTable = this.m_resultsPane.getResultsTable();
        this.m_listSelectionModel = this.m_resultsTable.getSelectionModel();
        this.m_logonUser = this.m_resultsPane.getLogonUser();
        this.m_mainContainer = this.m_resultsPane.getMainContainer();
        this.m_parentFrame = this.m_resultsPane.getParentFrame();
        if (this.m_logonUser == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLogonUser, VWResource.s_cancelTitle, 1, null);
            return;
        }
        if (!bAll && this.m_resultsTable.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(resultsPane.getParentFrame(), VWResource.s_noRowSelected, VWResource.s_cancelTitle, 1, null);
            return;
        }
        VWAdminConfirmDialog confirmDlg = null;
        confirmDlg = bAll ? new VWAdminConfirmDialog(this.m_parentFrame, VWResource.s_cancelTitle, VWResource.s_cancelAllWarning, 2) : new VWAdminConfirmDialog(this.m_parentFrame, VWResource.s_cancelTitle, VWResource.s_cancelWarning, 2);
        confirmDlg.setVisible(true);
        if (confirmDlg.isCanceled()) {
            return;
        }
        int[] rows = new int[this.m_resultsTable.getRowCount()];
        if (bAll) {
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = i;
            }
            this.buildWobsList(rows, bAll);
        } else {
            this.buildWobsList(this.m_selectedRows, bAll);
        }
        this.doCancel();
        if (bAll) {
            this.m_tableModel.refreshSelectedRows(rows);
        } else {
            this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
        }
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_cancelTitle, VWResource.s_cancelErr, this.m_vErrors);
            dlg.setVisible(true);
        }
        this.removeReferences();
    }

    private void buildWobsList(int[] rows, boolean bAll) {
        try {
            for (int i = 0; i < rows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rows[i]);
                if (bAll) {
                    if (woData.getLockedStatus() != 1 || !woData.isDirty()) continue;
                    this.m_wobsList.addElement(woData);
                    VWAdminCommon.addChildrenToWobsList(woData.getChildren(), true, this.m_wobsList);
                    continue;
                }
                this.m_wobsList.addElement(woData);
                VWAdminCommon.addChildrenToWobsList(woData.getChildren(), false, this.m_wobsList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void doCancel() {
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        for (int i = 0; i < this.m_wobsList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
            VWWorkObject wob = woData.getWob();
            try {
                wob.doAbort();
                wob.doRefresh(false, false);
                woData.setDirty(false);
                woData.updateLockedInfo();
                continue;
            }
            catch (Exception ex) {
                VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                this.m_vErrors.addElement(errObj);
                VWDebug.logException(ex);
            }
        }
    }

    private void selectWobs() {
        if (this.m_wobsList.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_wobsList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
            int rowIndex = woData.getRowIndex();
            if (woData.isDirty() || woData.getLockedStatus() != 3 || rowIndex < 0) continue;
            this.m_listSelectionModel.addSelectionInterval(rowIndex, rowIndex);
        }
    }

    private void removeReferences() {
        if (this.m_wobsList != null) {
            this.m_wobsList.removeAllElements();
        }
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
    }
}

